# System-wide .bashrc file for interactive bash(1) shells.

# To enable the settings / commands in this file for login shells as well,
# this file has to be sourced in /etc/profile.

# If not running interactively, don't do anything
[[ -z "${PS1}" ]] && \
  return

# check the window size after each command and, if necessary,
# update the values of LINES and COLUMNS.
shopt -s 'checkwinsize'

# Don't put duplicate lines or lines starting with space in the history.
# See bash(1) for more options
HISTCONTROL='ignoreboth'

# For setting history length see HISTSIZE and HISTFILESIZE in bash(1)
HISTSIZE='-1'
HISTFILESIZE='0'

# Set the cursor on tty.
setterm -cursor on

# For setting up the right system locale
export $(/usr/bin/grep --recursive 'LC_ALL' '/etc/default/locale')

# For a colored prompt, if the terminal has the capability; turned
# off by default to not distract the user: the focus in a terminal window
# should be on the output of commands, not on the prompt
FORCE_COLOR_PROMPT='no'

if [ "${FORCE_COLOR_PROMPT}" = 'no' ]; then
  if [ -x '/usr/bin/tput' ] && /usr/bin/tput setaf '1' &> '/dev/null'; then
    # We have color support; assume it's compliant with Ecma-48
    # (ISO/IEC-6429). (Lack of such support is extremely rare, and such
    # a case would tend to support setf rather than setaf.)
    COLOR_PROMPT='yes'
  else
    COLOR_PROMPT='no'
  fi
else
  COLOR_PROMPT='yes'
fi

if [ "${COLOR_PROMPT}" = 'yes' ]; then
  PS1="\[\e[38;5;1m\]╭─── \[\e[38;5;120m\]\u \[\e[38;5;250m\]@ \[\e[38;5;230m\]\H \[\e[38;5;1m\]─── \[\e[m\]\w \[\e[38;5;1m\]───┤ \[\e[38;5;120m\][ \t ]\n\[\e[38;5;1m\]╰─── \[\e[m\]"
  if [ -x '/usr/bin/dircolors' ]; then
    alias ls='ls --color'
    LS_COLORS='di=1;32:ln=35:so=37:pi=37:ex=1;31:bd=37:cd=37:su=1;31:sg=1;31:tw=32:ow=32'
    export LS_COLORS
  fi
else
  PS1="\[\e[38;5;1m\]╭─── \[\e[38;5;120m\]${debian_chroot:+($debian_chroot)}\u \[\e[38;5;250m\]@ \[\e[38;5;230m\]\H \[\e[38;5;1m\]─── \[\e[m\]\w \[\e[38;5;1m\]───┤ \[\e[38;5;120m\][ \t ]\n\[\e[38;5;1m\]╰─── \[\e[m\]"
fi

# Alias definitions.
# You may want to put all your additions into a separate file like
# ~/.bash_aliases, instead of adding them here directly.
# See /usr/share/doc/bash-doc/examples in the bash-doc package.
[ -f "${HOME}/.bash_aliases" ] && \
  . "${HOME}/.bash_aliases"

# Nano definitions.
# Make sure the backup folder for nano has been created.
[ ! -d "${HOME}/.nano" ] && \
  /usr/bin/install --directory "${HOME}/.nano" --mode '0700'
